


dofile("Scripts/Database/Weapons/warheads.lua") 

local GALLON_TO_KG = 3.785 * 0.8
local INCHES_TO_M = 0.0254
local POUNDS_TO_KG = 0.453592

local tracer_on_time = 0.01   
local barrel_smoke_level = 1.0
local barrel_smoke_opacity = 0.1  



    -- [1] = Cartridge, caliber .50, HE, M2
    declare_weapon({category = CAT_SHELLS, name = "Browning_HE_M2", user_name = _("12.7x99_HE_M2"),
        model_name      = "tracer_bullet_A-10",  
        projectile      = "Ball",
        mass            = 0.046, -- Bullet mass
        round_mass      = 0.117 + 0.020, -- Assembled shell + link
        cartridge_mass  = 0.012 + 0.000, -- Empty shell (+ link if links are stored as well)
        explosive       = 0.1,
		payload         = 0.1,
        payloadEffect   = "Fragmentation",
        payloadMaterial = "TNT",		
        v0              = 823.5,
        Dv0             = 0.0082,
        Da0             = 0.00085,
        Da1             = 0.0,
        life_time       = 7.0,
        caliber         = 12.7,
        s               = 0.0,
        j               = 0.0,
        l               = 0.0,
        charTime        = 0,
        cx              = {0.5, 0.61, 0.80, 0.17, 2.0},
        k1              = 1.4e-08,
        tracer_off      = -1,
        smoke_tail_life_time = 0,
        cartridge       = 0,
        scale_smoke     = barrel_smoke_level,
        smoke_opacity   = barrel_smoke_opacity,
    })

    -- [2] = Cartridge, caliber .50, armor piercing, M2
    declare_weapon({category = CAT_SHELLS, name = "Browning_AP_M2", user_name = _("12.7x99_AP_M2"),
        model_name      = "tracer_bullet_A-10",
        projectile      = "AP",
        mass            = 0.0458, -- Bullet mass
        round_mass      = 0.117 + 0.020, -- Assembled shell + link
        cartridge_mass  = 0.012 + 0.000, -- Empty shell (+ link if links are stored as well)
        explosive       = 0,
        v0              = 830.0,
        Dv0             = 0.0082,
        Da0             = 0.00085,
        Da1             = 0.0,
        life_time       = 7.0,
        caliber         = 12.7,
        s               = 0.0,
        j               = 0.0,
        l               = 0.0,
        charTime        = 0,
        cx              = {0.5, 0.61, 0.80, 0.17, 2.0},
        k1              = 1.4e-08,
        tracer_off      = -1,
        smoke_tail_life_time = 0,
        cartridge       = 0,
        scale_smoke     = barrel_smoke_level,
        smoke_opacity   = barrel_smoke_opacity,
    })

    -- [3] = Cartridge, caliber .50, armor-piercing incendiary, M8
    declare_weapon({category = CAT_SHELLS, name = "Browning_API_M8", user_name = _("12.7x99_API_M8"),
        model_name      = "tracer_bullet_A-10",
        projectile      = "AP",
        mass            = 0.0403, -- Bullet mass
        round_mass      = 0.114 + 0.020, -- Assembled shell + link
        cartridge_mass  = 0.012 + 0.000, -- Empty shell (+ link if links are stored as well)
        explosive       = 0.0,
        payload         = 0.1,
        payloadEffect   = "Thermal",
        payloadMaterial = "Thermite",
        v0              = 860.0,
        Dv0             = 0.0082,
        Da0             = 0.00085,
        Da1             = 0.0,
        life_time       = 7.0,
        caliber         = 12.7,
        s               = 0.0,
        j               = 0.0,
        l               = 0.0,
        charTime        = 0,
        cx              = {0.5, 0.61, 0.80, 0.17, 2.0},
        k1              = 1.35e-08,
        tracer_off      = -1,
        smoke_tail_life_time = 0,
        cartridge       = 0,
        scale_smoke     = barrel_smoke_level,
        smoke_opacity   = barrel_smoke_opacity,
    })

    -- [4] = Cartridge, caliber .50, armor-piercing incendiary tracer, M20
    declare_weapon({category = CAT_SHELLS, name = "Browning_APIT_M20", user_name = _("12.7x99_APIT_M20"),
        model_name      = "tracer_bullet_red",
        projectile      = "AP",
        mass            = 0.0410, -- Bullet mass
        round_mass      = 0.112 + 0.020, -- Assembled shell + link
        cartridge_mass  = 0.012 + 0.000, -- Empty shell (+ link if links are stored as well)
        --explosive       = 0.0000,
        payload         = 0.1,
        payloadEffect   = "Thermal",
        payloadMaterial = "Thermite",
        v0              = 875.0,
        Dv0             = 0.0082,
        Da0             = 0.00085,
        Da1             = 0.0,
        life_time       = 7.0,
        caliber         = 12.7,
        s               = 0.0,
        j               = 0.0,
        l               = 0.0,
        charTime        = 0,
        cx              = {0.5, 0.61, 0.80, 0.17, 2.0},
        k1              = 1.35e-08,
        tracer_off      = 4.0,
        smoke_tail_life_time = 0,
        cartridge       = 0,
        scale_smoke     = barrel_smoke_level,
        smoke_opacity   = barrel_smoke_opacity,
    })

    -- [5] = Cartridge, caliber .50, incendiary, M1
    declare_weapon({category = CAT_SHELLS, name = "Browning_I_M1", user_name = _("12.7x99_I_M1"),
        model_name      = "tracer_bullet_white",
        projectile      = "Ball",
        mass            = 0.0405, -- Bullet mass
        round_mass      = 0.115 + 0.02, -- Assembled shell + link
        cartridge_mass  = 0.012, -- Empty shell (+ link if links are stored as well)
        payload         = 0.1,
        payloadEffect   = "Thermal",
        payloadMaterial = "Thermite",
        v0              = 860,
        Dv0             = 0.0082,
        Da0             = 0.00085,
        Da1             = 0,
        life_time       = 7,
        caliber         = 12.7,
        s               = 0,
        j               = 0,
        l               = 0,
        charTime        = 0,
        cx              = {0.5, 0.61, 0.8, 0.17, 2},
        k1              = 1.35e-08,
        tracer_off      = -1,
        smoke_tail_life_time = 0,
        cartridge       = 0,
        scale_smoke     = barrel_smoke_level,
        smoke_opacity   = barrel_smoke_opacity, 
    })

    -- [6] = Cartridge, caliber .50, Tracer, M1
    declare_weapon({category = CAT_SHELLS, name = "Browning_T_M1", user_name = _("12.7x99_T_M1"),
        model_name      = "tracer_bullet_red",
        projectile      = "Ball",
        mass            = 0.0437, -- Bullet mass
        round_mass      = 0.116 + 0.02, -- Assembled shell + link
        cartridge_mass  = 0.012, -- Empty shell (+ link if links are stored as well)
        explosive       = 0,
        v0              = 875,
        Dv0             = 0.0082,
        Da0             = 0.00085,  
        Da1             = 0,
        life_time       = 7,
        caliber         = 12.7,
        s               = 0,
        j               = 0,
        l               = 0,
        charTime        = 0,
        cx              = {0.5, 0.61, 0.8, 0.17, 2}, 
        k1              = 1.35e-08,
        tracer_off      = 4,
        smoke_tail_life_time = 0,
        cartridge       = 0,
        scale_smoke     = barrel_smoke_level,
        smoke_opacity   = barrel_smoke_opacity,
    })





function OH6_FN_M3P(tbl)

	tbl.category = CAT_GUN_MOUNT 
	tbl.name 	 = "OH6_FN_M3P"
	tbl.supply 	 = 
	{
		shells = {					
					--"M2_12_7",
					--"M2_12_7_T", 
					--"M242_25_HE_M792",
					--"M2_50_aero_AP",
					--"M20_50_aero_APIT"
                --[[ 1 ]]   "Browning_HE_M2",
                --[[ 2 ]]   "Browning_AP_M2",
                --[[ 3 ]]   "Browning_API_M8",
                --[[ 4 ]]   "Browning_APIT_M20",
                --[[ 5 ]]   "Browning_I_M1",
                --[[ 6 ]]   "Browning_T_M1",

					
					}, 
		mixes	= {
					{1},
					{2},
					{3},
					{4},
					{5},
					{6},
				}, 
		count  = 500,
	}
	if tbl.mixes then 
	   tbl.supply.mixes =  tbl.mixes  
	   tbl.mixes	    = nil
	end
	tbl.gun = 
	{
		max_burst_length = 1,
		rates 			 = {1025},
		recoil_coeff 	 = 0.325,
		barrels_count 	 = 1,
	}
	if tbl.rates then 
	   tbl.gun.rates    =  tbl.rates  
	   tbl.rates	    = nil
	end	
	tbl.ejector_pos 			= {-1.099, -0.173, 0.101} -- position from muzzle connector pos
	tbl.ejector_dir 			= tbl.ejector_dir
	tbl.supply_position  		= tbl.supply_position or {0,  0, -1}
	tbl.aft_gun_mount 			= false
	tbl.effective_fire_distance = 3000
	tbl.drop_cartridge 			= 204 -- drop shell shape/size from  aircraft_gun_mounts.lua
	tbl.muzzle_pos				= tbl.muzzle_pos or {0,0,0} -- all position from connector
	tbl.muzzle_pos_connector	= tbl.muzzle_pos_connector 	or  "Gun_point" -- all position from connector
	tbl.azimuth_initial 		= tbl.azimuth_initial    or 0   
	tbl.elevation_initial 		= tbl.elevation_initial  or 0   
	if  tbl.effects == nil then
		tbl.effects = {{ name = "FireEffect"     , arg 		 = tbl.effect_arg_number or 436 },
					   { name = "HeatEffectExt"  , shot_heat = 7.823, barrel_k = 0.462 * 2.7, body_k = 0.462 * 14.3 },
					   { name = "SmokeEffect"}, 
					   }
	end
	return declare_weapon(tbl)
end

declare_loadout({
	category 		=   CAT_PODS, 
	CLSID	 		=  "{OH6_Browning_M3P_1}",  
	attribute		=   {wsType_Weapon,wsType_GContainer,wsType_Cannon_Cont,WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon	= 	{wsType_Weapon,wsType_Shell,wsType_Shell,WSTYPE_PLACEHOLDER},
	Picture			=	"oh58brau.png",
	displayName		=	_("FN M3P Combat Mix"),-- loadout editor name
	Weight			=	(500*0.11) + 37.42+9.34+19.1+2.22+3.65+0.82,
	Weight_Empty    = 	37.42+9.34+19.1+2.22+3.65+0.82,
	Cx_pil			=	0.00024,
	Elements  		= {{ShapeName = "oh58d_m3p_1"}},      
	kind_of_shipping = 2,--SOLID_MUNITION
	gun_mounts		= {
			OH6_FN_M3P({
				ejector_dir = {0,-1,-0.5},
				mixes					= {{1,2,4,5,1,4}},     
				muzzle_pos				= {0.0, 0.0, 0.0},   
				muzzle_pos_connector	= "Point_Gun",
				supply_position = {0, 0, -1}  
			})			
	},	
	shape_table_data = {{file  	 = 'oh58d_m3p_1';	username = 'FN M3P Combat Mix'; index = WSTYPE_PLACEHOLDER;}}
})

declare_loadout({
	category 		=   CAT_PODS, 
	CLSID	 		=  "{OH6_Browning_M3P_2}",  
	attribute		=   {wsType_Weapon,wsType_GContainer,wsType_Cannon_Cont,WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon	= 	{wsType_Weapon,wsType_Shell,wsType_Shell,WSTYPE_PLACEHOLDER},
	Picture			=	"oh58brau.png",
	displayName		=	_("FN M3P Tracer"),-- loadout editor name
	Weight			=	(500*0.11) + 37.42+9.34+19.1+2.22+3.65+0.82,
	Weight_Empty    = 	37.42+9.34+19.1+2.22+3.65+0.82,
	Cx_pil			=	0.00024,
	Elements  		= {{ShapeName = "oh58d_m3p_2"}},   
	kind_of_shipping = 2,--SOLID_MUNITION
	gun_mounts		= {
			OH6_FN_M3P({
				ejector_dir = {0,-1,-0.5},
				mixes					= {{4,6}},  
				muzzle_pos				= {0.0, 0.0, 0.0},
				muzzle_pos_connector	= "Point_Gun",
				supply_position = {0,  0, -1}  
			})			
	},	
	shape_table_data = {{file  	 = 'oh58d_m3p_2';	username = 'FN M3P Tracer'; index = WSTYPE_PLACEHOLDER;}}
})

declare_loadout({
	category 		=   CAT_PODS, 
	CLSID	 		=  "{OH6_Browning_M3P_3}",  
	attribute		=   {wsType_Weapon,wsType_GContainer,wsType_Cannon_Cont,WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon	= 	{wsType_Weapon,wsType_Shell,wsType_Shell,WSTYPE_PLACEHOLDER},
	Picture			=	"oh58brau.png",
	displayName		=	_("FN M3P HE/AP-T"),-- loadout editor name
	Weight			=	(500*0.11) + 37.42+9.34+19.1+2.22+3.65+0.82,
	Weight_Empty    = 	37.42+9.34+19.1+2.22+3.65+0.82,
	Cx_pil			=	0.00024,
	Elements  		= {{ShapeName = "oh58d_m3p_3"}},     
	kind_of_shipping = 2,--SOLID_MUNITION
	gun_mounts		= {
			OH6_FN_M3P({
				ejector_dir = {0,-1,-0.5},
				mixes					= {{1,4}},      
				muzzle_pos				= {0.0, 0.0, 0.0},        
				muzzle_pos_connector	= "Point_Gun",   
				supply_position = {0,  0, -1}  
			})			
	},	
	shape_table_data = {{file  	 = 'oh58d_m3p_3';	username = 'FN M3P HE/AP-T'; index = WSTYPE_PLACEHOLDER;}}
})






function OH6_FN_HMP400(tbl)

	tbl.category = CAT_GUN_MOUNT 
	tbl.name 	 = "OH6_FN_HMP400"
	tbl.supply 	 = 
	{
		shells = {					
					--"M2_12_7",
					--"M2_12_7_T", 
					--"M242_25_HE_M792",
					--"M2_50_aero_AP",
					--"M20_50_aero_APIT"
                --[[ 1 ]]   "Browning_HE_M2",
                --[[ 2 ]]   "Browning_AP_M2",
                --[[ 3 ]]   "Browning_API_M8",
                --[[ 4 ]]   "Browning_APIT_M20",
                --[[ 5 ]]   "Browning_I_M1",
                --[[ 6 ]]   "Browning_T_M1",

					
					}, 
		mixes	= {
					{1},
					{2},
					{3},
					{4},
					{5},
					{6},
				}, 
		count  = 400,
	}
	if tbl.mixes then 
	   tbl.supply.mixes =  tbl.mixes  
	   tbl.mixes	    = nil
	end
	tbl.gun = 
	{
		max_burst_length = 1,
		rates 			 = {1025},
		recoil_coeff 	 = 0.25*1.3,
		barrels_count 	 = 1,
	}
	if tbl.rates then 
	   tbl.gun.rates    =  tbl.rates
	   tbl.rates	    = nil
	end	
	tbl.ejector_pos 			= {0.0, 0.0, 0.0} -- position from muzzle connector pos
	tbl.ejector_dir 			= tbl.ejector_dir
	tbl.supply_position  		= tbl.supply_position or {0,  0.3, -0.3}
	tbl.aft_gun_mount 			= false
	tbl.effective_fire_distance = 3000
	tbl.drop_cartridge 			= 0 -- drop shell shape/size from  aircraft_gun_mounts.lua
	tbl.muzzle_pos				= tbl.muzzle_pos or {0,0,0} -- all position from connector
	tbl.muzzle_pos_connector	= tbl.muzzle_pos_connector 	or  "Gun_point" -- all position from connector
	tbl.azimuth_initial 		= tbl.azimuth_initial    or 0   
	tbl.elevation_initial 		= tbl.elevation_initial  or 0   
	if  tbl.effects == nil then
		tbl.effects = {{ name = "FireEffect"     , arg 		 = tbl.effect_arg_number or 436 },
					   { name = "HeatEffectExt"  , shot_heat = 7.823, barrel_k = 0.462 * 2.7, body_k = 0.462 * 14.3 },
					   { name = "SmokeEffect"}, 
					   }
	end
	return declare_weapon(tbl)
end

declare_loadout({
	category 		=   CAT_PODS, 
	CLSID	 		=  "{OH6_FN_HMP_1}",  
	attribute		=   {wsType_Weapon,wsType_GContainer,wsType_Cannon_Cont,WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon	= 	{wsType_Weapon,wsType_Shell,wsType_Shell,WSTYPE_PLACEHOLDER},
	Picture			=	"l081.png",
	displayName		=	_("FN HMP400 HE/AP-T"),-- loadout editor name
	Weight				= 89 + (400 * 0.11), -- INCLUDE AMMO FOR FULL WEIGHT
    Weight_Empty        = 89,
	Cx_pil			=	0.001220703125,
	Elements  		= {{ShapeName = "HMP400_1"}},     
	kind_of_shipping = 2,--SOLID_MUNITION
	gun_mounts		= {
			OH6_FN_HMP400({
				ejector_dir = {0,-1,-0.5},
				mixes					= {{1,4}},      
				muzzle_pos				= {0.0, 0.0, 0.0},               
				muzzle_pos_connector	= "Point_Gun",   
				supply_position = {2, -0.3, -0.4}  
			})			
	},	
	shape_table_data = {{file  	 = 'HMP400_1';	username = 'FN HMP400 HE/AP-T'; index = WSTYPE_PLACEHOLDER;}}
})

declare_loadout({
	category 		=   CAT_PODS, 
	CLSID	 		=  "{OH6_FN_HMP_2}",  
	attribute		=   {wsType_Weapon,wsType_GContainer,wsType_Cannon_Cont,WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon	= 	{wsType_Weapon,wsType_Shell,wsType_Shell,WSTYPE_PLACEHOLDER},
	Picture			=	"l081.png",
	displayName		=	_("FN HMP400 Combat Mix"),-- loadout editor name
	Weight				= 89 + (400 * 0.11), -- INCLUDE AMMO FOR FULL WEIGHT
    Weight_Empty        = 89,
	Cx_pil			=	0.001220703125,
	Elements  		= {{ShapeName = "HMP400_2"}},     
	kind_of_shipping = 2,--SOLID_MUNITION
	gun_mounts		= {
			OH6_FN_HMP400({
				ejector_dir = {0,-1,-0.5},
				mixes					= {{1,2,4,5,1,4}},      
				muzzle_pos				= {0.0, 0.0, 0.0},           
				muzzle_pos_connector	= "Point_Gun",   
				supply_position = {2, -0.3, -0.4}  
			})			
	},	
	shape_table_data = {{file  	 = 'HMP400_2';	username = 'FN HMP400 Combat Mix'; index = WSTYPE_PLACEHOLDER;}}
})

declare_loadout({
	category 		=   CAT_PODS, 
	CLSID	 		=  "{OH6_FN_HMP_3}",  
	attribute		=   {wsType_Weapon,wsType_GContainer,wsType_Cannon_Cont,WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon	= 	{wsType_Weapon,wsType_Shell,wsType_Shell,WSTYPE_PLACEHOLDER},
	Picture			=	"l081.png",
	displayName		=	_("FN HMP400 Tracer"),-- loadout editor name
	Weight				= 89 + (400 * 0.11), -- INCLUDE AMMO FOR FULL WEIGHT
    Weight_Empty        = 89,
	Cx_pil			=	0.001220703125,
	Elements  		= {{ShapeName = "HMP400_3"}},     
	kind_of_shipping = 2,--SOLID_MUNITION
	gun_mounts		= {
			OH6_FN_HMP400({
				ejector_dir = {0,-1,-0.5},
				mixes					= {{4,6}},      
				muzzle_pos				= {0.0, 0.0, 0.0},              
				muzzle_pos_connector	= "Point_Gun",   
				supply_position = {2, -0.3, -0.4}  
			})			
	},	
	shape_table_data = {{file  	 = 'HMP400_3';	username = 'FN HMP400 Tracer'; index = WSTYPE_PLACEHOLDER;}}
})
  